/*
 ============================================================================
 Name        : FP_kernel.c
 Author      : Yixiang
 Version     :
 Copyright   : Your copyright notice
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#ifndef MODULE
#define MODULE
#endif

#ifndef __KERNEL__
#define __KERNEL__
#endif

#include	<linux/module.h>
#include	<linux/kernel.h>
#include	<asm/io.h>
#include	<rtai.h>
#include	<rtai_sched.h>
#include	<rtai_fifos.h>
#include    <linux/time.h>
#include	<rtai_sem.h>

MODULE_LICENSE("GPL");

int lightflag = 0; //flag used to update the status of red LED

#define IRQ_SOFT 63 //software interrupt line 63

static RT_TASK mytask1,mytask2,mytask3; //declear 3 real time tasks

void light_switch_button(int t)		//task for detecting the button press
{
	unsigned long *pBbase, *pBdr;	//registers for Port B

	pBbase = (unsigned long *)__ioremap(0x80840000,4096,0);	//mapping the address
	pBdr = (unsigned long*)((char *)pBbase + 0x4);

	rtf_create(1,sizeof(lightflag));	//create ﬁfo 1 used to communicate with
										//a pthread in userspace
	while(1)
	{

		if((!(*pBdr & 0x1)))	//whenever the button is pressed
		{
			*pBdr ^= 0x20;		//switch the Red LED
		}

		if( *pBdr & 0x20 )		//when the switch operation is finished, check
			lightflag = 1;		//the bit value for Red LED and change the flag
		else					//value
			lightflag = 0;
		rt_sleep(nano2count(150000000));

		rtf_put(1, &lightflag, sizeof(lightflag));	//send the lightflag status
    												//to pthread1 at userspace through
													//fifo 1
	}
}

void light_switch_touch(int t)	//task for detecting the touch sensor
{
	unsigned long *pBbase, *pBdr;	//registers for Port B
	unsigned long *pAddr, *pAdr;	//registers for Port A

	pBbase = (unsigned long *)__ioremap(0x80840000,4096,0);	//mapping the address
	pBdr = (unsigned long*)((char *)pBbase + 0x4);

	pAddr	 = 	(unsigned long *)((char *)pBbase + 0x10);
	pAdr 	 = 	(unsigned long *)((char *)pBbase + 0x00);

	*pAddr &= 0xFFFFFFFD;	//set PortA bit 1 as input to detect the touch sensor

	int warningflag = 1;
	rtf_create(0,sizeof(warningflag));	//create ﬁfo 0 which used to communicate with
										//another pthread in the userspace
	while(1)
	{
		if(!(*pAdr & 0x02))		//whenever the sensor is touchedcd
		{
			*pBdr ^= 0x20;      //switch the Red light
			rtf_put(0, &warningflag, sizeof(warningflag));	//send the flag to pthread2
		}
		if( *pBdr & 0x20 )		//when the switch operation is finished, check
			lightflag = 1;		//the bit value for Red LED and change the flag
		else					//value
			lightflag = 0;
		rt_sleep(nano2count(150000000));
	}
}

void light_switch_sound(int t)	//task for detecting the sound
{
	unsigned long *pBbase, *pBdr;	//registers for Port B

	//Registers for using MAX197 A/D converter, there are two registers being used here, the first is
	//from address 0x10F0_0000 which initiate the A/D conversion and store the converted data. The
	//second is from address 0x1080_0000 which is used for checking if the conversion is completed or
	//not

	volatile unsigned short *complete;	//registers for completetion check
	volatile unsigned char *lsb, *msb, *control;	//"control" is for convertion initialization.
													//"lsb, msb" are for data storage.

	int res;	//store the decimal number data after conversion

	pBbase = (unsigned long *)__ioremap(0x80840000,4096,0);	//mapping the address
	pBdr = (unsigned long*)((char *)pBbase + 0x4);
	lsb = control = (unsigned char *)__ioremap(0x10f00000,4096,0);
	msb = lsb + 1;	//least and most significant bit for store the binary data
	complete = (unsigned short*)__ioremap(0x10800000,4096,0);

	while(1)
	{
		*control = 0x40;	//Initiate conversion, channel 0,unipolar, 5V

		while((*complete & 0x80)!= 0)	//wait for completion
		{
		}
		res = *lsb;	//store result on a scale from 0 to 2^12-1
		res |= *msb << 8;
		if( res < 2800 )		//2800 is the base line for the sound signal to be able to trigger the switch
		{
			*pBdr ^= 0x20;		//switch the Red LED
		}
		if( *pBdr & 0x20 )		//when the switch operation is finished, check
			lightflag = 1;		//the bit value for Red LED and change the flag
		else					//value
			lightflag = 0;
		rt_sleep(nano2count(150000000));
	}
}

//Software interrupt handler will be trigger when the userspace receive a "SWITCH" command,
//then the interrupt will switch the value for the red LED bit.

static void soft_interrupt_handler(unsigned irq_num, void *cookie)
{
	unsigned long *VIC2SoftIntClear, *VIC2base;	//software interrupt registers
	unsigned long *pBbase, *pBddr, *pBdr;	//registers for Port B

	pBbase = (unsigned long *)__ioremap(0x80840000,4096,0);	//mapping the address
	pBddr = (unsigned long*)((char *)pBbase + 0x14);
	pBdr = (unsigned long*)((char *)pBbase + 0x4);

	VIC2base = (unsigned long *)__ioremap(0x800C0000,4096,0);
	VIC2SoftIntClear = (unsigned long*)((char *)VIC2base + 0x1C);

	rt_disable_irq(IRQ_SOFT);	//disable interrupt

	*pBdr ^= 0x20;	//switch the Red LED

	if( *pBdr & 0x20 )	//when the switch operation is finished, check
		lightflag = 1;	//the bit value for Red LED and change the flag
	else				//value
		lightflag = 0;

	*VIC2SoftIntClear |= 0x80000000;	//clear bits in the VIC2SoftInt Register

	rt_enable_irq(IRQ_SOFT);
}

//The main function does most of the initialization work
int init_module(void)
{
	unsigned long *pBbase, *pBddr, *pBdr;	//Port B registers
	unsigned long *VIC2base, *VIC2IntEnable, *VIC2SoftIntClear;	//software interrupt registers

	pBbase = (unsigned long *)__ioremap(0x80840000,4096,0); //mapping the address
	pBddr = (unsigned long*)((char *)pBbase + 0x14);
	pBdr = (unsigned long*)((char *)pBbase + 0x4);

	VIC2base = (unsigned long *)__ioremap(0x800C0000,4096,0);
	VIC2IntEnable = (unsigned long*)((char *)VIC2base + 0x10);
	VIC2SoftIntClear = (unsigned long*)((char *)VIC2base + 0x1C);

	*pBddr |= 0xE0;			//set all three lights as output
	*pBddr &= 0xFFFFFFFE;	//set the button as input
	*pBdr &= 0xFFFFFF1F;	//turn off all the lights at the beginning

	//initialize real time task
	rt_set_periodic_mode();			//set to periodic mode
	start_rt_timer(nano2count(1000000));

	//initialize real time task
	rt_task_init(&mytask1,light_switch_button,0,256,1,0,0);
	rt_task_init(&mytask2,light_switch_sound,0,256,1,0,0);
	rt_task_init(&mytask3,light_switch_touch,0,256,1,0,0);

	//start all real time tasks
	rt_task_resume(&mytask1);
	rt_task_resume(&mytask2);
	rt_task_resume(&mytask3);

	//attach the software handler to the interrupt line
	rt_request_irq(IRQ_SOFT, soft_interrupt_handler, 0, 1);

	*VIC2IntEnable    |= 0x80000000;	//enable the interrupt request lines
	*VIC2SoftIntClear |= 0x80000000;	//Clear bits in the VIC2SoftInt Register

	rt_enable_irq(IRQ_SOFT);	//enable the software interrupt

	return 0;
}

void cleanup_module(void)
{
	unsigned long *pBbase, *pBddr, *pBdr;

	pBbase = (unsigned long *)__ioremap(0x80840000,4096,0);
	pBddr = (unsigned long*)((char *)pBbase + 0x14);
	pBdr = (unsigned long*)((char *)pBbase + 0x4);

	*pBddr |= 0xE0;			//set all three lights as output
	*pBddr &= 0xFFFFFFFE;	//set the button as input
	*pBdr &= 0xFFFFFF1F;	//turn off all the lights at the beginning

	rt_task_delete(&mytask1);			//delete real time task
	rt_task_delete(&mytask2);
	rt_task_delete(&mytask3);
	stop_rt_timer();					//stop timer
	rt_release_irq(IRQ_SOFT);			//release interrupt line
	rtf_destroy(0);						//destroy the fifos
	rtf_destroy(1);
}
